// Autor: Ante Derek

#include <iostream>
#include <string>
#include <cassert>

using namespace std;

const int MAX = 1000;

int n;
char command[MAX];
char variable[MAX];
int value[MAX];
int level[MAX];

int main() {
  cin >> n;
  for (int i=0; i<n; i++) {
    string cmd;
    cin >> cmd;
    command[i] = cmd[0];
    if (command[i] == 'w') {
      string var;
      cin >> var;
      variable[i] = var[0];
    } else if (command[i] == 'v') {
      string var;
      string eq;
      cin >> var >> eq >> value[i];
      variable[i] = var[0];
    } else {
      assert(command[i] == 'b' || command[i] == 'e');
    }
  }
  
  int current = 0;
  for (int i=0; i<n; i++) {
    if (command[i] == 'e')
      current--;
    level[i] = current;
    if (command[i] == 'b')
      current++;
    assert(current >= 0);
    if (i < n-1)
      assert(current > 0);
  }
  assert(current == 0);

  for (int i=0; i<n; i++)
    if (command[i] == 'w') {
      int target = level[i];
      int done = 0;
      cerr << i << " " << variable[i] << endl;
      for (int j=i-1; j>=0 && !done; j--) {
        if (level[j] < target)
          target = level[j];
        if (level[j] > target)
          continue ;
        if (command[j] == 'v' && variable[j] == variable[i]) {
          cout << value[j] << endl;
          done = 1;
        }
      }
      assert(done);
    }

  return 0;
}
